/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.belt;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dev.gigaherz.toolbelt.belt.ToolBeltInventory;
import dev.gigaherz.toolbelt.common.Screens;
import dev.gigaherz.toolbelt.customslots.ExtensionSlotItemHandler;
import dev.gigaherz.toolbelt.customslots.IExtensionContainer;
import dev.gigaherz.toolbelt.customslots.IExtensionSlot;
import dev.gigaherz.toolbelt.customslots.IExtensionSlotItem;
import dev.gigaherz.toolbelt.customslots.example.RpgEquipment;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class ToolBeltItem
extends Item
implements IExtensionSlotItem,
DyeableLeatherItem {
    public static Capability<IItemHandler> ITEM_HANDLER = CapabilityManager.get((CapabilityToken)new CapabilityToken<IItemHandler>(){});
    public static Capability<IExtensionSlotItem> EXTENSION_SLOT_ITEM = CapabilityManager.get((CapabilityToken)new CapabilityToken<IExtensionSlotItem>(){});
    public static final ImmutableSet<ResourceLocation> BELT_SLOT_LIST = ImmutableSet.of((Object)RpgEquipment.BELT);
    public static int[] xpCost = new int[]{3, 5, 8, 12, 15, 20, 30};

    public ToolBeltItem(Item.Properties properties) {
        super(properties);
    }

    private static int getSlotFor(Inventory inv, ItemStack stack) {
        if (inv.m_36056_() == stack) {
            return inv.f_35977_;
        }
        for (int i = 0; i < inv.f_35974_.size(); ++i) {
            ItemStack invStack = (ItemStack)inv.f_35974_.get(i);
            if (invStack != stack) continue;
            return i;
        }
        return -1;
    }

    private InteractionResult openBeltScreen(@Nullable Player player, ItemStack stack, Level world) {
        int slot;
        int n = slot = player != null ? ToolBeltItem.getSlotFor(player.m_150109_(), stack) : -1;
        if (slot == -1) {
            return InteractionResult.FAIL;
        }
        if (!world.f_46443_ && player instanceof ServerPlayer) {
            Screens.openBeltScreen((ServerPlayer)player, slot);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43724_() != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        return this.openBeltScreen(context.m_43723_(), context.m_43722_(), context.m_43725_());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (hand != InteractionHand.MAIN_HAND) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        InteractionResult result = this.openBeltScreen(player, stack, world);
        return new InteractionResultHolder(result, (Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        int size = ToolBeltItem.getSlotsCount(stack);
        tooltip.add((Component)new TranslatableComponent("text.toolbelt.tooltip", new Object[]{size - 2, size}));
    }

    @Override
    @Nonnull
    public ImmutableSet<ResourceLocation> getAcceptableSlots(@Nonnull ItemStack stack) {
        return BELT_SLOT_LIST;
    }

    @Override
    public void onWornTick(ItemStack itemstack, IExtensionSlot slot) {
        this.tickAllSlots(itemstack, slot.getContainer().getOwner());
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof LivingEntity) {
            this.tickAllSlots(stack, (LivingEntity)entityIn);
        }
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag nbt) {
        return new ICapabilityProvider(){
            final ItemStack owner;
            final ToolBeltInventory itemHandler;
            final LazyOptional<IItemHandler> itemHandlerInstance;
            final LazyOptional<IExtensionSlotItem> extensionSlotInstance;
            {
                this.owner = stack;
                this.itemHandler = new ToolBeltInventory(stack);
                this.itemHandlerInstance = LazyOptional.of(() -> this.itemHandler);
                this.extensionSlotInstance = LazyOptional.of(() -> ToolBeltItem.this);
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == ITEM_HANDLER) {
                    return this.itemHandlerInstance.cast();
                }
                if (cap == EXTENSION_SLOT_ITEM) {
                    return this.extensionSlotInstance.cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.m_41746_((ItemStack)oldStack, (ItemStack)newStack);
    }

    public static int getSlotsCount(ItemStack stack) {
        int size = 2;
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null) {
            size = Mth.m_14045_((int)nbt.m_128451_("Size"), (int)2, (int)9);
        }
        return size;
    }

    public static void setSlotsCount(ItemStack stack, int newSize) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
            nbt.m_128365_("Items", (Tag)new ListTag());
        }
        nbt.m_128405_("Size", newSize);
        stack.m_41751_(nbt);
    }

    public static int getUpgradeXP(ItemStack stack) {
        int slots = ToolBeltItem.getSlotsCount(stack);
        if (slots >= 9) {
            return -1;
        }
        if (slots < 2) {
            return 1;
        }
        return xpCost[slots - 2];
    }

    public static ItemStack upgrade(ItemStack stack) {
        int slots = ToolBeltItem.getSlotsCount(stack);
        if (slots >= 9) {
            return stack.m_41777_();
        }
        stack = stack.m_41777_();
        ToolBeltItem.setSlotsCount(stack, slots + 1);
        return stack;
    }

    public ItemStack of(int upgradeLevel) {
        if (upgradeLevel < 0 || upgradeLevel >= 9) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = new ItemStack((ItemLike)this);
        ToolBeltItem.setSlotsCount(stack, upgradeLevel + 2);
        return stack;
    }

    public int getLevel(ItemStack stack) {
        return ToolBeltItem.getSlotsCount(stack) - 2;
    }

    private void tickAllSlots(ItemStack source, LivingEntity player) {
        BeltExtensionContainer container = new BeltExtensionContainer(source, player);
        for (IExtensionSlot slot : container.getSlots()) {
            ((ExtensionSlotItemHandler)slot).onWornTick();
        }
    }

    public static class BeltExtensionContainer
    implements IExtensionContainer {
        private static final ResourceLocation SLOT_TYPE = new ResourceLocation("toolbelt", "pocket");
        private final ToolBeltInventory inventory;
        private final LivingEntity owner;
        private final ImmutableList<IExtensionSlot> slots;

        public BeltExtensionContainer(ItemStack source, LivingEntity owner) {
            this.inventory = (ToolBeltInventory)source.getCapability(ITEM_HANDLER, null).orElseThrow(() -> new RuntimeException("No inventory!"));
            this.owner = owner;
            Object[] slots = new ExtensionSlotItemHandler[this.inventory.getSlots()];
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                slots[i] = new ExtensionSlotItemHandler(this, SLOT_TYPE, this.inventory, i){

                    @Override
                    public boolean canEquip(@Nonnull ItemStack stack) {
                        return inventory.canInsertItem(this.slot, stack);
                    }
                };
            }
            this.slots = ImmutableList.copyOf((Object[])slots);
        }

        @Override
        @Nonnull
        public LivingEntity getOwner() {
            return this.owner;
        }

        @Override
        @Nonnull
        public ImmutableList<IExtensionSlot> getSlots() {
            return this.slots;
        }

        @Override
        public void onContentsChanged(IExtensionSlot slot) {
        }
    }
}

